﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Microsoft.Win32;
using Winfoot_7_SDK;
using WinfootDefaultNetworkPlugin.Controls.Strategy;

namespace WinfootDefaultNetworkPlugin.Controls
{
    public partial class EnableDeadGWDetect : UserControl,IControl,ICorrespondenceOS
    {
        private EnableDeadGWDetectController enableDeadGWDetectController;

        public EnableDeadGWDetect()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsSeven
#endif
                                       };
            
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.google.co.jp/"));
                userHelp.Show();
            }
        }

        public void SetEnableDeadGWDetectValue(int i)
        {
            switch (i)
            {
                case 0:
                    checkBox1.Checked = false;
                    break;
                case 1:
                    checkBox1.Checked = true;
                    break;
                default:
                    break;
            }
        }


        public int GetEnableDeadGWDetectValue()
        {
            if (checkBox1.Checked)
            {
                return 1;
            }
            return 0;
        }

        #region IControl メンバ

        public void Apply()
        {
            enableDeadGWDetectController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return enableDeadGWDetectController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void EnableDeadGWDetect_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            enableDeadGWDetectController = new EnableDeadGWDetectController(this,
                                                                                      (IEnableDeadGWDetectStrategy)
                                                                                      wfUtillity.
                                                                                          GetCorrespondenceInstance
                                                                                          (new List<ICorrespondenceOS>
                                                                                               {
                                                                                                   new EnableDeadGWDetectDefaultStrategy()
                                                                                               }));
            enableDeadGWDetectController.Read();
        }
    }

}
